/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.CommandNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandsNode
extends BaseNode<Property> {
    private static final Image COMMANDS_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private CommandNode[] commands;

    CommandsNode(BundleElement bundle) {
        this(bundle.getCommands());
    }

    CommandsNode(List<CommandElement> elements) {
        LinkedList<CommandNode> items = new LinkedList<CommandNode>();
        if (elements != null) {
            Collections.sort(elements);
            for (CommandElement command : elements) {
                if (command instanceof SnippetElement) continue;
                items.add(new CommandNode(command));
            }
        }
        this.commands = items.toArray(new CommandNode[items.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.commands;
    }

    @Override
    public Image getImage() {
        return COMMANDS_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.CommandsNode_Commands_Node;
    }

    @Override
    public boolean hasChildren() {
        return this.commands.length > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<CommandsNode>
    {
        COUNT(Messages.CommandsNode_Commands_Count){

            public Object getPropertyValue(CommandsNode node) {
                return node.commands.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

